// ##     ##    ###    ########           ## ##     ## ##     ## ########  
// ###   ###   ## ##   ##     ##          ## ##     ## ###   ### ##     ## 
// #### ####  ##   ##  ##     ##          ## ##     ## #### #### ##     ## 
// ## ### ## ##     ## ########           ## ##     ## ## ### ## ########  
// ##     ## ######### ##           ##    ## ##     ## ##     ## ##        
// ##     ## ##     ## ##           ##    ## ##     ## ##     ## ##        
// ##     ## ##     ## ##            ######   #######  ##     ## ##          
//
//                  __       __)             __     __)                   
//     /)          (, )  |  /      ,        (, /|  /|          /)         
//    // _____        | /| /  __    _/_  _    / | / |  _____  (/_   _     
//   /(_(_)/ (_       |/ |/  / (__(_(___(/_) /  |/  |_(_) / (_/(___(/_(_/_
//  /)                /  |                (_/   '                    .-/  
// (/                                                               (_/     


MAP_WIDTH = 200;
MAP_ZOOM_FACTOR = .2;

INSERT_COMMENTED = true; // if false, ascii text will be inserted without comment marks but with tabs
ADD_BOOKMARK = false; // only relevant if INSERT_COMMENTED is true
BOOKMARK_ON_BOTTOM = false; // only relevant if INSERT_COMMENTED is true; false = on top

USE_PROXY = false;
PROXY_URL = "proxy.gov.si";
PROXY_PORT = 80;

MAP_ON_S = "Map view on";
MAP_OFF_S = "Map view off";



// Complete list of fonts: http://www.figlet.org/examples.html
var fonts = [
	"colossal", // 0 -> default
	"doh",
	"banner3",
	"isometric1",
	"lean",
	"invita",
	"standard",
	"nancyj",
	"big",
	"roman" // 9
];


// as bookmark
// commented out
// tabbed - markdown

// monkey.richTextBox.MinimumSize = new System.Drawing.Size(MAP_WIDTH, 200);

var bookmarkString = monkey.settings["_bookmarkString"];
var bookmarkName = "";

var oldWidth, oldZoomFactor;
var mapOn = false;


// Connect to API - as simple as it gets!
getStringFromAPI = function(lookup, font) {
	try {

		var webClient = new System.Net.WebClient();

		if (USE_PROXY) {
			var webProxy = new System.Net.WebProxy(PROXY_URL, PROXY_PORT);
			webClient.Proxy = webProxy;
		}

		var textS = webClient.DownloadString("http://artii.herokuapp.com/make?text=" + lookup.replace(/ /g, "%20") + "&font=" + font);
		webClient.Dispose();
		return (textS == "" || textS == null) ? false : textS;
	} catch (err) {
		return false;
	}
};



prepareString = function(text) {

	var pre = (INSERT_COMMENTED) ? "// " : "\t";
	var bookmark = (ADD_BOOKMARK && INSERT_COMMENTED) ? bookmarkString + " " + bookmarkName : "";


	var line = "";
	var newString = "";

	var r = new System.IO.StringReader(text);

	while ((line = r.ReadLine()) != null) {
		if (/^\s*$/.test(line) == false) { // use only if not blank line
			newString += pre + line + "\r\n";
		}
	}
	return (BOOKMARK_ON_BOTTOM ) ? newString + bookmark : bookmark + "\r\n" + newString;
};


asciify = function() {

	if (monkey.selectionLength <= 0) {
		monkey.select(monkey.paragraphUnderCaretStart, monkey.paragraphUnderCaretEnd - monkey.paragraphUnderCaretStart);
	}
	var text = monkey.selectedText.Trim();


	// check for font id or use default
	if (/^.+\/[0-9]$/.test(text)) {
		var font = fonts[0 + text.charAt(text.length)];
		text = text.replace(/\/[0-9]/, "");
	} else {
		var font = fonts[0];
	}


	bookmarkName = text;
	var fromAPI = getStringFromAPI(text, font);
	monkey.selectedText = prepareString(fromAPI);
	monkey.performSyntaxColoring();
};



toggleMap = function() {
	if (mapOn) {
		monkey.setSettingValue("_width", oldWidth);
		monkey.setSettingValue("_zoomFactor", oldZoomFactor);
		monkey.richTextBox.ZoomFactor = oldZoomFactor;
		monkey.richTextBox.PositionRtbE();
		mapOn = false;
		monkey.showNotice(MAP_OFF_S, true, false);
	} else {
		

		oldWidth = monkey.richTextBox.Width;
		oldZoomFactor = monkey.richTextBox.ZoomFactor;

		monkey.setSettingValue("_width", MAP_WIDTH);
		monkey.setSettingValue("_zoomFactor", MAP_ZOOM_FACTOR);
		monkey.richTextBox.ZoomFactor = MAP_ZOOM_FACTOR;
		monkey.richTextBox.PositionRtbE();
		mapOn = true;
		monkey.showNotice(MAP_ON_S, false, false);

	}
};


newLocationFromMap = function() {
	if (mapOn) {
		monkey.select(monkey.selectionStart, 0);
		monkey.setSettingValue("_width", oldWidth);
		monkey.setSettingValue("_zoomFactor", oldZoomFactor);
		monkey.richTextBox.ZoomFactor = oldZoomFactor;
		monkey.scrollToCaret();
		monkey.richTextBox.PositionRtbE();
		mapOn = false;
		monkey.showNotice(MAP_OFF_S, true, false);
	}
};

// EVENTS


monkey.add_keyDownE(function(object, eventargs) {

	// Bypass auto indent if shift + enter
	if (eventargs.KeyCode == System.Windows.Forms.Keys.D6 && System.Windows.Forms.Control.ModifierKeys == System.Windows.Forms.Keys.Control) {
		eventargs.SuppressKeyPress = true;
		eventargs.Handled = true;

		asciify();
	} else if (eventargs.KeyCode == System.Windows.Forms.Keys.D5 && System.Windows.Forms.Control.ModifierKeys == System.Windows.Forms.Keys.Control) {
		toggleMap();
	}

});


monkey.richTextBox.add_MouseDoubleClick(function(object, eventargs) {
	newLocationFromMap();
});

// monkey.richTextBox.add_MouseUp(function(object, eventargs) {
// 	newLocationFromMap();
// });


monkey.form.add_MouseDoubleClick(function(object, eventargs) {
	toggleMap();
});


// monkey.richTextBox.add_SizeChanged(function(object, eventargs) {
// 	if (mapOn) {
// 		mapOn = false;
// 		monkey.showNotice(MAP_OFF_S, true, false);
// 	}
// });